

#ifndef _JPath_H_
#define _JPath_H_

#include "JPoint.h"
#include "FingerPoints.h"
#include <vector>
#include <deque>

using namespace std;

/**
   JPath is a rendering helper class for managing lists of points
   @author Josh Nimoy
   for Gabe Dunne
   23 jan 2007

   may 2007 - added funky shit for GRL
   aug 2009 - added funky shit for brush2
*/

class JPath{
public:
	float stroke_width; ///< change this to tell stroke() how fat to go.
	FingerPrint rnd; ///< my own personal randoms in case i need them
	deque<JPoint>points;///< my internal JPoint list
	
	deque<JPoint> animation;
	deque<JPoint> animation_normals;
	deque<JPoint> animation_tangents;
	float frameCount;
	float vertexCount;

	
	JPath(); ///< construct me empty but don't expect anything to render until you've pushed some points in.
	JPath(JPath *mentor); ///< construct a new jpath and copy jpoints from another path.
	JPath(vector<JPoint>); ///< construct a new jpath copying this list of points.
	JPath(deque<JPoint>); ///< construct a new jpath copying this list of points.
	~JPath();
	void melt(float heat); ///< lerp each points closer to one another. Pass 0.5 for the most melting action.
	void subdiv();///< divide each segment into two.
	void glVertex();///< convenience function that loops through the points and calls glVertex for you. One more hidden for loop for you not to write.
	void ofVert();///< convenience function that loops through the points and calls glVertex for you. One more hidden for loop for you not to write.
	void fromBezier(JPoint p1,JPoint p2,JPoint p3,JPoint p4,int steps); ///< construct a path from bezier handles.
	void smooth(int val); ///< my favourite function of 2007. Higher level call than melt and subdiv.
	void println(); ///< cout wrapper. nough said.
	void render(); ///< draw a gl line
	void renderPoints(); ///< draw a gl point list
	void renderAsBezier(int steps); ///< use the points as bezier handles and do a gl line strip.
	void stroke(int steps,bool bez); ///< a rather large function that makes a wormy looking thing. Not exactly reusable. Tweak at will. Please mind my alchemy.
	void reset(); ///< reset the state machine for the stroke function and clear the points vector.
	void drink(FingerPoints f, int offset); ///< do a drunk man on all the points.
	void shrink(float v); ///< go towards the calculated middle by some amount - way non-reusable.
	JPoint average(); ///< average the points out and return one single point.
  
	void operator+=(JPoint p);
	void operator*=(JPoint p);
	void operator/=(JPoint p);
	
	void operator+=(float f);
	void operator*=(float f);
	void operator/=(float f);
	
	void resetVars(); ///< reset ONLY the finite state machine vars.

	bool useInnerFill; ///< fill the stroke like it's a solid snake.
	bool useOutline; ///< outline the snake with its own gl line outline.
  
	void eatPointsFromBothEnds(int bites); ///< make the snake shorter.

	float stroke_flare; ///< how much to flare out the stroke
	int stroke_style; ///< 0 or 1 for now. not really planned.

	void strokeRandomOverlap(float width,float angle);
	void strokeRibbon(float width,float angle);
	void outlineTube(float width);
	void vertexTube(float width,bool ofVertex);
	JPoint getTopLeft();
	JPoint getBottomRight();
	JPoint getCenter();
	void strokePaint(float width);
	float getLength();
	void push_back_point(JPoint p);
	void simplify(float tolerance);
	void bevelAngles(float bevelAmount);
	
	void strokeJoinCap(float width, float capAngle1,float capAngle2);	///< uses miter joins and caps
	deque<JPoint> applyJoins(deque<JPoint>);
	deque<JPoint> applyCap(JPoint,JPoint,float);

	deque<deque<JPoint> > getTriangleStrip(float width);
	
	void segment(float length);
	void loadDat(const char*filename);
	void updateFrame(int);
	JPoint pointOnCurve(float gradient);
	bool valid;///< whether the DAT file was corrupt
	void operator << (JPoint);
};



#endif

